/*
 * Decompiled with CFR 0.152.
 */
package xmlstreamparser;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import xmlstreamparser.HttpNode;

public class Node {
    public Node parent;
    public String name;
    public Hashtable attributes;
    public String text;
    public Vector children;

    public Node(Node _parent) {
        this.parent = _parent;
        this.name = "";
        this.attributes = new Hashtable(4);
        this.text = "";
        this.children = new Vector(3, 1);
        if (this.parent != null) {
            this.parent.children.addElement(this);
        }
    }

    public Node(HttpNode _node) {
        this.name = _node.name;
        this.text = _node.value;
        this.attributes = _node.attributes;
        this.children = new Vector(3, 1);
        this.setChildren(_node.childs);
    }

    private void setChildren(Vector http) {
        if (http != null) {
            for (int i = 0; i < http.size(); ++i) {
                this.children.addElement(new Node((HttpNode)http.elementAt(i)));
            }
        }
    }

    public String getValue(String _attributeName) {
        return (String)this.attributes.get(_attributeName);
    }

    public Node getChild(String _nodeName) {
        boolean found = false;
        Node tmp = null;
        for (int i = 0; i < this.children.size() && !found; ++i) {
            tmp = (Node)this.children.elementAt(i);
            if (!tmp.name.equals(_nodeName)) continue;
            found = true;
        }
        if (!found) {
            tmp = null;
        }
        return tmp;
    }

    public Node getChild(String _nodeName, String _attrName, String _attrVal) {
        boolean found = false;
        Node tmp = null;
        for (int i = 0; i < this.children.size() && !found; ++i) {
            tmp = (Node)this.children.elementAt(i);
            if (!tmp.name.equals(_nodeName) || !tmp.getValue(_attrName).equals(_attrVal)) continue;
            found = true;
        }
        if (!found) {
            tmp = null;
        }
        return tmp;
    }

    public Vector getChildren() {
        return this.children;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(64);
        buffer.append('<');
        buffer.append(this.name);
        Enumeration keys = this.attributes.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            buffer.append(' ');
            buffer.append(key);
            String value = (String)this.attributes.get(key);
            if (value == "") continue;
            buffer.append("='");
            buffer.append(value);
            buffer.append("'");
        }
        buffer.append('>');
        buffer.append(this.text);
        for (int i = 0; i < this.children.size(); ++i) {
            Node child = (Node)this.children.elementAt(i);
            buffer.append(child.toString());
        }
        buffer.append("</");
        buffer.append(this.name);
        buffer.append('>');
        return buffer.toString();
    }
}

